; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define APPName "Camera Driver 2.1.6.1"

[Setup]

AppId={{DD32B070-F135-47D4-9CC7-18E6A596130F}
AppName=Camera Driver
AppVerName={#APPName}
;AppPublisher=Tucsen
;AppPublisherURL=www.tucsen.com
;AppSupportURL=www.tucsen.com
;AppUpdatesURL=www.tucsen.com
;CreateAppDir=
DirExistsWarning=No
DisableProgramGroupPage=yes
DisableDirPage=yes
DisableReadyPage=yes
DisableWelcomePage=no

OutputDir=output
OutputBaseFilename={#APPName}
Compression=lzma
SolidCompression=yes

DefaultDirName={pf}\Camera Driver


ShowLanguageDialog=Yes
VersionInfoDescription=Camera Driver
VersionInfoVersion=2.1.6.1


ArchitecturesInstallIn64BitMode=x64 ia64

[Messages]
;BeveledLabel=


[Languages]
Name: "English"; MessagesFile: "compiler:Default.isl"
Name: "ChineseSimp"; MessagesFile: "compiler:Languages\ChineseSimp.isl"

[Components]
;Name: "vcredist_2008"; Description: "vcredist_2008";   Types: full
;Name: "vcredist_2013"; Description: "vcredist_2013";   Types: full




[Files]


;source: "..\ext\plugin\vcredist_2008\vcredist_2008_x64.exe"; DestDir: "{app}"; 
;Source: "..\ext\plugin\vcredist_2008\vcredist_2008_x86.exe"; DestDir: "{app}";
;source: "..\ext\plugin\vcredist_2013\vcredist_vs2013_x86.exe"; DestDir: "{app}"; 
;source: "..\ext\plugin\vcredist_2013\vcredist_vs2013_x64.exe"; DestDir: "{app}";  

Source: compiler:psvince.dll; Flags: dontcopy 
Source: compiler:psvince.dll; DestDir: "{app}"; Flags: ignoreversion

;SDK
;X86

;source: "..\ext\sdk\x86\*"; DestDir: "{sys}"; Flags: ignoreversion; check: not Is64BitInstallMode;


;X64

;source: "..\ext\sdk\x64\*"; DestDir: "{win}\System32"; Flags: ignoreversion; check: Is64BitInstallMode; 
;source: "..\ext\sdk\x86\*"; DestDir: "{syswow64}"; Flags: ignoreversion; check: Is64BitInstallMode;


;Driver

;WIN7
;Source: "win7\x86\*"; DestDir: "{app}"; Flags: ignoreversion; check: IsOtherArch; MinVersion: 6.1; OnlyBelowVersion: 6.2;
;Source: "win7\x64\*"; DestDir: "{app}"; Flags: ignoreversion; check: IsX64; MinVersion: 6.1; OnlyBelowVersion: 6.2;

;WIN10
Source: "D:\з\USBDriver_20250926\V2.1.6.1\Neutral Version\drivers\x86\*"; DestDir: "{app}"; Flags: ignoreversion; check: IsOtherArch; MinVersion: 6.4; 
Source: "D:\з\USBDriver_20250926\V2.1.6.1\Neutral Version\drivers\x64\*"; DestDir: "{app}"; Flags: ignoreversion; check: IsX64; MinVersion: 6.4; 



Source: "D:\Driver\ioDriver\x86\*"; DestDir: "{app}\x86"; Flags: ignoreversion; 
Source: "D:\Driver\ioDriver\amd64\*"; DestDir: "{app}\amd64"; Flags: ignoreversion; check: IsX64
Source: "D:\Driver\ioDriver\dpscat.exe"; DestDir: "{app}"; MinVersion: 4.1,5.0 ;Flags: ignoreversion;  Permissions: everyone-Full

Source: "D:\Driver Installation Tools2.1\DIFx\dpinst\MultiLin\x86\DPInst.exe"; DestDir: "{app}";Check: IsOtherArch; MinVersion: 4.1,5.0 ;Flags: ignoreversion;  Permissions: everyone-Full
Source: "D:\Driver Installation Tools2.1\DIFx\dpinst\MultiLin\amd64\DPInst.exe"; DestDir: "{app}";Check: IsX64; MinVersion: 4.1,5.0 ;Flags: ignoreversion;  Permissions: everyone-Full
Source: "D:\Driver Installation Tools2.1\DIFx\dpinst\MultiLin\ia64\DPInst.exe"; DestDir: "{app}"; Check: IsIA64; MinVersion: 4.1,5.0 ;Flags: ignoreversion;  Permissions: everyone-Full

[UninstallDelete]
Type: filesandordirs; Name: "{app}"
Type: filesandordirs; Name: "{app}\psvince.dll"



[Run]
Filename: "{app}\DPinst.exe"; parameters:"/sw"; MinVersion: 4.1,5.0;
;Filename: "{app}\vcredist_2008_x86.exe";Components: vcredist_2008;MinVersion: 4.1,5.0;
;Filename: "{app}\vcredist_2008_x64.exe";Components: vcredist_2008;MinVersion: 4.1,5.0;
;Filename: "{app}\vcredist_vs2013_x86.exe";Components: vcredist_2013;MinVersion: 4.1,5.0;
;Filename: "{app}\vcredist_vs2013_x64.exe";Components: vcredist_2013;MinVersion: 4.1,5.0;




[Code]
function IsX64: Boolean;
begin
  Result := Is64BitInstallMode and (ProcessorArchitecture = paX64);
end;

function IsIA64: Boolean;
begin
  Result := Is64BitInstallMode and (ProcessorArchitecture = paIA64);
end;

function IsOtherArch: Boolean;
begin
  Result := not IsX64 and not IsIA64;
end;


procedure DeinitializeSetup();
begin
//ļɾ

//If FileExists(ExpandConstant('{win}\inf\TCM510.inf')) Then DeleteFile(ExpandConstant('{win}\inf\TCM510.inf'));
  //If FileExists(ExpandConstant('{win}\inf\TucsenH.inf')) Then DeleteFile(ExpandConstant('{win}\inf\TucsenH.inf'));
  If FileExists(ExpandConstant('{win}\inf\tuusb3.inf')) Then DeleteFile(ExpandConstant('{win}\inf\tuusb3.inf'));
  If FileExists(ExpandConstant('{win}\inf\ioDriver.inf')) Then DeleteFile(ExpandConstant('{win}\inf\ioDriver.inf'));
end;


var
Errorcode: integer;
isRunning: integer;
//isExisting: Boolean;
Retcode:integer;
isAppRunning:Boolean;


function IsModuleLoaded(modulename: String ):  Boolean;
external 'IsModuleLoaded@files:psvince.dll stdcall setuponly';

function IsModuleLoadedU(modulename: String ):  Boolean;
external 'IsModuleLoaded@{app}\psvince.dll stdcall uninstallonly' ;

function initializeSetup(): Boolean;
begin
Result:=True;
//isRunning:=FindWindowByWindowName('TCapture');
isAppRunning:=IsModuleLoaded('Camera Driver.exe')
//while isRunning<>0 do
while isAppRunning do
begin
  Result:=msgbox('Please close the Camera Driver program and then click "Yes" to continue the installation or click "No" to concel it', mbConfirmation,MB_YESNO)=idYes
  if Result=False then
  begin
    msgbox('Finish installation. Please click "OK" to exit!',mbInformation, MB_OK)
    isAppRunning:=False;
    //isRunning:=0;
  end
  else begin
    isAppRunning:=IsModuleLoaded('Camera Driver.exe')
    //isRunning:=FindWindowByWindowName('TCapture');
  end;
end;
    

if Result=True then
  begin
    Result:=FileExists(ExpandConstant('{pf}\Camera Driver\unins000.dat'));
    //isExisting:=True;
    if Result=True then
    begin
      Result:=msgbox('The installation program detect this or the earlier version program is installed.'#13'Click "Yes" to uninstall the program first (recommended) or click "No" to exit the installation.', mbConfirmation, MB_YESNO)=idYes
      //Result:=False
      if Result=True then
      begin
        Exec(ExpandConstant('{pf}')+'\Camera Driver\unins000.exe','','',SW_HIDE,ewWaitUntilTerminated, RetCode);
        Result:=False;
        if FileExists(ExpandConstant('{pf}\TCapture\CalibrationTable.ini')) then
        begin
          Result:=msgbox('Do you want to keep the program registry information and configuration file?'#13'"Yes" keep the files or "No" delete all these files.',mbConfirmation, MB_YESNO)=idYes
          if Result=False then
          begin
            RegDeleteKeyIncludingSubkeys(HKEY_CURRENT_USER, 'Software\TUCSEN')
            deleteFile(ExpandConstant('{pf}\TCapture\CalibrationTable.ini'))
            deleteFile(ExpandConstant('{pf}\TCapture\MeasureAttribute.ini'))
          end;
        end;
        Result:=True;
      end
      else begin
        msgbox('Finish installation',mbinformation,MB_OK )
        Result:=False;
      end;
    end
    else begin
      Result:=True;
    end;
  end;
//Result:=isExisting;
end;


function InitializeUninstall(): Boolean;
begin
   Result:=True;
  //Result := MsgBox('жسڳʼУȷҪô?'#13#13'""""ȡжء', mbConfirmation, MB_YESNO) = idYes;
  //if Result = False then
  //begin
    //MsgBox('жسֹ밴"ȷ"˳', mbInformation, MB_OK);
  //end
  //else begin
    //Result:=true;
    //isRunning:=FindWindowByWindowName('Capture2.3');
    isAppRunning:=IsModuleLoadedU('Capture2.3.exe');
    //While isRunning<>0 do
    while isAppRunning do
    begin
      Result:=Msgbox('Camera driver is still running!'#13'Please close and then click "Yes" to continue the uninstall or click "No" to cancel it.', mbConfirmation,MB_YESNO)=idYes;
      if Result=False then
      begin
        msgbox('Finish uninstall, please press "OK" to exit!',mbInformation, MB_OK)
        //isRunning:=0;
        isAppRunning:=False;
      end
      else begin
        //Result:=true;
        //isRunning:=FindWindowByWindowName('Capture2.3');
        isAppRunning:=IsModuleLoadedU('Capture.exe');
      end;
    end;

  //end;
  UnloadDLL(ExpandConstant('{app}\psvince.dll'));
end;

[UninstallRun]
Filename: "{app}\DPinst.exe"; parameters:"/D /U tuusb3.inf";MinVersion: 4.1,5.0;
;Filename: "{app}\Dpscat.exe"; parameters:"/D"; MinVersion: 4.1,5.0;








